package com.izenpe.zain.cliente.util;

import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

import org.apache.axis.encoding.Base64;

public class CalcularHash {
	
	public static String getHash(String fichero)throws Exception{
		FileInputStream fileInputStream = new FileInputStream(fichero);
		DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, MessageDigest.getInstance("SHA1"));
		
		byte[] buff = new byte[8*1024];
		long inicio = System.currentTimeMillis();
		int read = digestInputStream.read(buff);
		while (read > 0) {
			read = digestInputStream.read(buff);
		}
		byte[] digest = digestInputStream.getMessageDigest().digest();
		long fin = System.currentTimeMillis();
		System.out.println("Hash (base64): "+Base64.encode(digest));
		System.out.println("Tamao hash: "+digestInputStream.getMessageDigest().getDigestLength() * 8 + " bits.");
		System.out.println("Tiempo de clculo de hash: " + ((fin-inicio)/1000) + " seg.");
		return Base64.encode(digest);
	}
}
